local assets=
{
	Asset("ANIM", "anim/moonlight.zip"),
	Asset("IMAGE", "images/inventoryimages/moonlight.tex"),
	Asset("ATLAS", "images/inventoryimages/moonlight.xml"),
}


local function hurtowner(inst, owner)
	if (owner.components.health) then
		owner.components.health:DoDelta(-2,-1)
end
end

local function onequip(inst, owner) 
    if owner:HasTag("antirad") then
	owner.AnimState:OverrideSymbol("swap_body", "moonlight", "swap_body")
	owner:AddTag("rad")
	else
	owner.AnimState:OverrideSymbol("swap_body", "moonlight", "swap_body")
	inst.task = inst:DoPeriodicTask(2, hurtowner, nil, owner)
	owner:AddTag("rad")
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner:RemoveTag("rad")
	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
end

local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("moonlight")
    inst.AnimState:SetBuild("moonlight")
    inst.AnimState:PlayAnimation("idle", false)
    

    inst:AddComponent("inspectable")
	
	inst:AddTag("backpack")
    	
	-- inst:AddComponent("stackable")
	-- inst.components.stackable.maxsize = 1
	
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/moonlight.xml"
 
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 15
	
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_LARGE	
	
    return inst
end

return Prefab( "common/inventory/moonlight", fnab, assets) 